#include "function.h"

extern BYTE ColorTable[1028];
/********get the color table for our bitmap file***************/
void readColorTable()
{
	FILE *fp;
	if(!(fp = fopen("ColorTable", "rb")))
	{
		printf("cannot open the color table file!");
		return;
	}
	fread(ColorTable, 1, 1028, fp);
	fclose(fp);
}
/*****calculate the max element in an array*********/
int myMax(int *cNum, int cNum_num)
{
	int Max;
	Max	= cNum[0];

	for(int i = 1; i < cNum_num; i ++)
		if(cNum[i] > Max)
			Max = cNum[i];
	return Max;
}

/*****calculate the sum of elements in an array*********/
int sum(BYTE *a, int id)
{
	if(id < 0)
		return 0;
	else
	{
		int Sum = 0;
		for(int i = 0; i <= id; i ++)
			Sum += (int)a[i];
		return Sum;
	}
}

/**********updown the matrix***************************/
void reverseRow(BYTE *data)
{
	BYTE temp;
	//temp = (BYTE *)malloc(sizeof(BYTE) * 128 * 128);
	int i;
	int up = 0;
	int down = 127;
	while(up < down)
	{
		for(i = 0; i < 128; i ++)
		{
			temp = data[up * 128 + i];
			data[up * 128 + i] = data[down * 128 + i];
			data[down * 128 + i] = temp;
		}
		up ++;
		down --;
	}
}